#include <iostream>
#include <boost/asio.hpp>
#include <boost/date_time/posix_time/posix_time.hpp>

using namespace std;

void event(const boost::system::error_code&) {
	cout << "timer event" << endl;
}


int main() {
	boost::asio::io_service io;
	boost::asio::deadline_timer t1(io, boost::posix_time::seconds(3));
	cout << "run synchronously ... " << flush;
	t1.wait(); //run synchrously
	cout << "timer event" << endl;

	boost::asio::deadline_timer t2(io, boost::posix_time::seconds(3));
	cout << "run asynchronously ... " << flush;
	t2.async_wait(event);

	io.run();
	return 0;
}
