/** przyklad użycia operacji atomowych */

#include <boost/thread/thread.hpp>
#include <thread>
#include <atomic>
#include <iostream>

const int MAXCOUNT = 5000000;

std::atomic<int> counter(0);

void thread_fun() {
	for(int i=0;i<MAXCOUNT;++i) {
		++counter;
	}
}

int main() {
	const int NUM = std::thread::hardware_concurrency();
    std::cout << NUM << " concurrent threads are supported.\n";
    boost::thread_group thrds;
    for (auto i=0; i < NUM; ++i)
        thrds.create_thread(&thread_fun);
    thrds.join_all();
	std::cout << "counter: " << counter << std::endl;
    return 0;
}



