/** przyklad uzycia blokady, modyfikacja obiektu w sekcji krytycznej */

#include <boost/thread/mutex.hpp>
#include <boost/thread/thread.hpp>
#include <iostream>
#include <thread>

const int MAXCOUNT = 5000000;
int counter;
boost::mutex mutex;


void thread_fun() {
	for(int i=0;i<MAXCOUNT;++i) {
		boost::mutex::scoped_lock scoped_lock(mutex);
		++counter;
	}
}

int main() {
	const int NUM = std::thread::hardware_concurrency();
    std::cout << NUM << " concurrent threads are supported.\n";
    boost::thread_group thrds;
    for (int i=0; i < NUM; ++i)
        thrds.create_thread(&thread_fun);
    thrds.join_all();
	std::cout << "counter: " << counter << std::endl;
    return 0;
}



