#ifndef BUFFER_H
#define BUFFER_H

/** plik zawiera klasy, ktore reprezentuja wejscie i wyjscie dla filtrow tekstowych */

#include <mutex>
#include <queue>

namespace filter {

    /** abstrakcyjna klasa bazowa */
	class InOut {
	public:
		static const char FINISHED = '\0';

		virtual ~InOut(){}
		virtual void put(char c) = 0;
		virtual bool get(char& c) = 0;
	};

	/** klasa wyjscia do strumienia */
	class OutStream : public InOut {
	public:
		OutStream(std::ostream& os) : os_(os) {}
		~OutStream(){ os_.flush(); }
		virtual void put(char c) { if(c != FINISHED) os_.put(c); }
		virtual bool get(char& c) { c = FINISHED; return false; }
	private:
		OutStream& operator=(const OutStream&);
		std::ostream& os_;
	};

	/** klasa wejscia ze strumienia */
	class InStream : public InOut {
	public:
		InStream(std::istream& is) : is_(is) {}

		virtual bool get(char& c) {
			if(is_) { c = is_.get(); return true; }
			else { c = FINISHED; return false; }
		}
		virtual void put(char) { }
	private:
		InStream& operator=(const InStream&);
		std::istream& is_;
	};

	/** klasa wejscia - wyjscia do kolejki znakow */
	class InOutQueue : public InOut {
	public:
		InOutQueue(){}
		virtual void put(char c) {
			std::lock_guard<std::mutex> lock(mutex);
			dane_.push(c);
		}
		virtual bool get(char& c) {
			bool read = false;
			while(!read) {
				std::lock_guard<std::mutex> lock(mutex);
				if( ! dane_.empty() ) {
					c = dane_.front();
					dane_.pop();
					read = true;
				}
			}
			return c != FINISHED;
		}
	private:
		std::queue<char> dane_;
		std::mutex mutex;
	};

} //namespace

#endif
