/** przyklad wyscigu i uzycia blokady */
#include <vector>
#include <iostream>
#include <thread>
#include <mutex>

class Counter
{
public:
    Counter() : count_(0) { }
	int getC() const { return count_; }
    void setC(int val) { count_ = val; }
private:
    int count_;
};

Counter counter;
std::mutex mutex;

void thread_fun() {
	for(int i=0;i<1000000;++i) {
		std::lock_guard guard(mutex);
		counter.setC( counter.getC() + 1);
	}
}

int main() {
    const int NUM = std::thread::hardware_concurrency();
    std::cout << NUM << " concurrent threads are supported by platform.\n";
	std::vector<std::thread> thrds;

	thrds.reserve(NUM);
    for (int i=0; i < NUM; ++i) {
        thrds.emplace_back(&thread_fun);
	}
	//join_all
	for(int i=0; i< NUM; ++i)
		thrds[i].join();

	std::cout << "counter: " << counter.getC() << std::endl;
    return 0;
}



