/** przerywanie watku */

#include <iostream>
#include <string>
#include <chrono>
#include <thread>
#include <mutex>


using namespace std;

class OStream {
public:
	OStream(std::ostream& os) : os_(os) {}
	OStream& operator<<(const std::string& s) {
		lock_guard<mutex> lock(m_);
		os_ << s << flush;
		return *this;
	}
private:
	ostream& os_;
	mutex m_; // mutex do synchronizacji z ostream
};

OStream out(cout);

class MyThread {
public:
	MyThread() : finish_(false) {}
	void finish() { finish_ = true; }
	void operator()() {
		while(!finish_) {
			this_thread::sleep_for(chrono::seconds(1));
			out << ".";
		}
		out << " przerwano ";
	}
private:
	volatile bool finish_;
};
int main() {
	MyThread my_thread;
    thread thrd( ref(my_thread) );
	out << " Uruchomiony watek uzytkownika.";
	this_thread::sleep_for(chrono::seconds(6));
	out << " Wygenerowano przerwanie.";
	my_thread.finish();
	if(thrd.joinable()) {
		thrd.join();
	}
	out  << " Zakonczony watek uzytkownika.";
    return 0;
}



