#ifndef FILTERS_H
#define FILTERS_H

#include "buffers.hpp"

/** plik zawiera filtry tekstowe */

namespace filter {

	/** abstrakcyjna klasa bazowa */
	class FilterFunctor {
	public:
		FilterFunctor(InOut& in, InOut& out) : in_(in), out_(out) {}
		virtual ~FilterFunctor(){}
		/** ogolny schemat postepowania dla dowolnego filtru */
		void operator()() {
			char ch;
			while(in_.get(ch) ) {
				filter(ch);
			}
			out_.put(InOut::FINISHED);
		}
	protected:
		/** metoda, ktora przetwarza pojedynczy znak. Zalezna od rodzaju filtru */
		virtual void filter(char ch) = 0;
		InOut& in_;
		InOut& out_;
	};

	/** filtr, ktory zamienia grupe bialych znakow pojedyncza spacja */
	class DeleteWhiteFunctor : public FilterFunctor {
	public:
		DeleteWhiteFunctor(InOut& in, InOut& out) : FilterFunctor(in, out), drop_(false) {}
		virtual void filter(char ch) {
			if( !isspace(ch) ) {
				drop_ = false;
				out_.put(ch);
			} else if(!drop_ ) {
				out_.put(' ');
				drop_ = true; //bedzie pomijal biale znaki
			}
		}
	private:
		bool drop_;
	};

	/** filtr, ktory po n znakach wstawia znak nowej linii */
	class CutLineFunctor : public FilterFunctor {
	public:
		CutLineFunctor(InOut& in, InOut& out, int max) : FilterFunctor(in, out), max_(max), count_(0) {}

		virtual void filter(char ch) {
			out_.put(ch);
			++count_;
			if(count_ == max_) {
				out_.put('\n');
				count_ = 0;
			}
		}
	private:
		int max_;
		int count_;
	};

}

#endif
