#include <string>
#include <vector>

using namespace std;

// Ponizej pokazano fragment kodu gry w warcaby.
// Obiekt typu 'State' reprezentuje stan w grze, tzn. polozenie pionow, damek oraz informacja o tym, kto sie rusza.
// Dostarczamy trzech roznych wersji gry: warcaby włoskie, warcaby niemieckie i warcaby hiszpanskie.
// Wszystkie takie wersje uzywaja planszy 8x8, ale roznia sie mozliwoscia bicia pionem do tyłu oraz możliwością ruchu damki o wiele pól.
// Te modyfikacje wplywaja na implementacje metod 'validMovementsXXX'.
// Dostarczamy takze trzy algorytmy dla gracza: algorytm losowy - wybiera jeden z dostepnych ruchow losowo, algorytm AI - wybiera jeden z dostepnych ruchow
// wykorzystujac algorytmy przeszukiwania drzewa gry oraz algorytm 'Human', ktory o propozycje ruchu pyta gracza.

// Uprosc strukture klas, aby nie powielac kodu.


/** reprezentuje stan w grze w warcaby (polozenie pionow i informacja o tym, kto sie rusza */
struct State {};
using States = vector<State>;

class Player {
 virtual State nextMove(State s) = 0;
};

class ItalianAIPlayer : public Player {
public:
 ItalianAIPlayer();
 State nextMove(State s);
private:
 States validMovementsItalian(State s);
};

class GermanAIPlayer : public Player {
public:
 GermanAIPlayer();
 State nextMove(State s);
private:
 States validMovementsItalian(State s);
};

class SpanishAIPlayer : public Player {
public:
 SpanishAIPlayer();
 State nextMove(State s);
private:
 States validMovementsItalian(State s);
};


class ItalianRandomPlayer : public Player {
public:
 ItalianRandomPlayer();
 State nextMove(State s);
private:
 States validMovementsItalian(State s);
};

class GermanRandomPlayer : public Player {
public:
 GermanRandomPlayer();
 State nextMove(State s);
private:
 States validMovementsItalian(State s);
};

class SpanishRandomPlayer : public Player {
public:
 SpanishRandomPlayer();
 State nextMove(State s);
private:
 States validMovementsItalian(State s);
};


class ItalianHumanPlayer : public Player {
public:
 ItalianHumanPlayer();
 State nextMove(State s);
private:
 States validMovementsItalian(State s);
};

class GermanHumanPlayer : public Player {
public:
 GermanHumanPlayer();
 State nextMove(State s);
private:
 States validMovementsItalian(State s);
};

class SpanishHumanPlayer : public Player {
public:
 SpanishHumanPlayer();
 State nextMove(State s);
private:
 States validMovementsItalian(State s);
};

//Rozwiazanie: wzorzec mostu

// class Checkers { //klasa bazowa implementacji - rozne rodzaje warcabow
// public:
//    virtual States validMovements(State s) = 0;
// };

// class ItalianCheckers : public Checkers {
//     virtual States validMovements(State s);
// };

// class GermanCheckers : public Checkers {
//     virtual States validMovements(State s);
// };

// class SpanishCheckers : public Checkers {
//     virtual States validMovements(State s);
// };

// class Player {
// public:
//     Player(Checkers& ch) : checkers_(ch) {}

//     virtual State nextMove(State s) = 0;
// protected:
//     virtual States validMovements(State s) {
//         return checkers_.validMovements(s);
//     }
// private:
//     Checkers& checkers_;
// };

// class RandomPlayer : public Player {
// public:
//     RandomPlayer(Checkers& ch) : Player(ch) {}
//     State nextMove();
// };

// class AIPlayer : public Player {
// public:
//     AIPlayer(Checkers& ch) : Player(ch) {}
//     State nextMove();
// };

// class HumanPlayer : public Player {
// public:
//     HumanPlayer(Checkers& ch) : Player(ch) {}
//     State nextMove();
// };

int main() {
    return 0;
}
