#ifndef VISITORS_H
#define VISITORS_H

#include "figury.hpp"
#include <cmath>

using namespace std;

class VisitorCountRect : public Visitor {
public:
    VisitorCountRect() : count_(0) {}
	void visit(const Square& ) override { ++count_;}
	void visit(const Circle& ) override { }
    int get() const { return count_; }
private:
    int count_;
};

class VisitorArea : public Visitor {
public:
    VisitorArea() : area_(0.0) {}
    void visit(const Square& s) override { area_ += s.getSide()*s.getSide(); }
    void visit(const Circle& c) override {
		area_ += c.getRadius() * c.getRadius() * M_PI;
	}
    double getArea() const { return area_; }
private:
    double area_;
};

class VisitMaxSquare : public Visitor {
public:
	VisitMaxSquare() : maxSide_(0) {}
	void visit(const Square& s) override {
		if(s.getSide() > maxSide_ )
			maxSide_ = s.getSide();
	}
	void visit(const Circle& ) override { }
	int getMaxSide() const { return maxSide_; }
private:
	int maxSide_;
};
#endif
