#include <Stack.h>

#include <catch2/catch_test_macros.hpp>

using namespace swo::tdd;

TEST_CASE("new stack is empty", "[stack]") {
  Stack s;

  REQUIRE(s.isEmpty());
}

TEST_CASE("after push stack is no longer empty", "[stack]") {
  Stack s;

  s.push(1);

  REQUIRE_FALSE(s.isEmpty());
}

TEST_CASE("after push and pop stack is again empty", "[stack]") {
  Stack s;

  s.push(1);
  s.pop();

  REQUIRE(s.isEmpty());
}

TEST_CASE("after two pushes and pop stack is still not empty", "[stack]") {
  Stack s;

  s.push(1);
  s.push(1);
  s.pop();

  REQUIRE_FALSE(s.isEmpty());
}

// TODO pop on empty

TEST_CASE("stack pops correct value", "[stack]") {
  Stack s;

  s.push(42);

  REQUIRE(s.pop() == 42);
}
