#include <Stack.h>

#include <catch2/catch_test_macros.hpp>

using namespace swo::tdd;

TEST_CASE("new stack is empty", "[stack]") {
  Stack s;
  REQUIRE(s.isEmpty());
}

TEST_CASE("after push stack is no longer empty", "[stack]") {
  Stack s;

  s.push(1);

  REQUIRE(!s.isEmpty());
}

TEST_CASE("after push and pop stack is again empty", "[stack]") {
  Stack s;

  s.push(1);
  s.pop();

  REQUIRE(s.isEmpty());
}

TEST_CASE("after two pushes and a single pop stack is not empty empty", "[stack]") {
  Stack s;

  s.push(1);
  s.push(2);
  s.pop();

  REQUIRE(!s.isEmpty());
}
