/* testujacy - pokazuje przykładową klasę z leniwym kopiowaniem (copy on write) */

#include <iostream>
#include <memory>

using namespace std;

class Foo {
public:
	Foo(int v) : val_(v) { cout << "c-tor" << endl; }
	int get() const { return val_; }
	void set(int v) { val_ = v; }
private:
	int val_;
};

class LazyFoo {
public:
	LazyFoo(int i) : ptr_(new Foo(i) ) {}
	LazyFoo(const LazyFoo& l) : ptr_(l.ptr_) {}
	int get() const { return ptr_->get(); }
	void set(int i) {
		if(ptr_.unique() ) { ptr_->set(i); }
		else { ptr_ = PFoo(new Foo(i) ); }
	}
private:
	typedef shared_ptr<Foo> PFoo;
	PFoo ptr_;
};

int main() {
	cout << "line: " << __LINE__ << endl;
	LazyFoo x(1);
	cout << "line: " << __LINE__ << endl;
	LazyFoo y(x);
	cout << "line: " << __LINE__ << endl;
	y.get();
	cout << "line: " << __LINE__ << endl;
	x.set(2);
	cout << "line: " << __LINE__ << endl;
	y.set(3);
	cout << "line: " << __LINE__ << endl;
	return 0;
}
