#ifndef FIG_HPP
#define FIG_HPP

/**
   modul demonstruje wzorzec prototypu (wirtualnego konstruktora)
   dla SWO.
 */

class Fig {
public:
	int getId() const { return id; }

	virtual ~Fig() {}
	virtual Fig* clone() const = 0;
	virtual void draw() const = 0;
private:
	int id;
};

class Rect : public Fig {
public:
	Fig* clone() const override;
	void draw() const override;
};

class Circle : public Fig {
public:
	Fig* clone() const override;
	void draw() const override;
};

#endif //FIG_HPP
