#ifndef LOGGER_HPP
#define LOGGER_HPP
/** modul do zarzadzania komunikatami diagnostycznymi */

#include <string>
#include <iostream>

/** singleton do rejestracji komunikatow */
class Logger {
public:
	static Logger& getInstance() {
		static Logger logger;
		return logger;
	}

	/** rejestracja komunikatu */
	void msg(const std::string& m) {
		std::cout << ++counter_ << ":" << m << std::endl;
	}
private:
	int counter_;
	Logger() : counter_(0) {}

	Logger(const Logger&) = delete;
	Logger& operator=(const Logger&) = delete;
};

#endif //LOGGER_HPP
