#ifndef FIGURY_H
#define FIGURY_H

class Visitor;
class Figure { //klasa bazowa w hierarchii klas
public:
    virtual void accept(Visitor& v) const = 0;
    virtual ~Figure(){}
};
class Square;
class Circle;
class Visitor { //wizytor abstrakcyjny
public:
    virtual void visit(const Square& k) = 0;
    virtual void visit(const Circle& o) = 0;
    virtual ~Visitor(){}
};
class Square : public Figure {
public:
    Square(int s) : side_(s) {}
    int getSide() const { return side_; }
	void accept(Visitor& v) const override {v.visit(*this);}
private:
    int side_;
};
class Circle : public Figure {
public:
    Circle(int r) : r_(r) {}
    int getRadius() const { return r_; }
	void accept(Visitor& v) const override {v.visit(*this);}
private:
    int r_;
};
#endif
