#include <vector>
#include <iostream>
#include "visitors.hpp"

using namespace std;
typedef vector<Figure*> Figures;

int main() {
	Figures fig;
	fig.push_back(new Square(10) );
	fig.push_back(new Circle(3) );
	fig.push_back(new Circle(1) );

	VisitorCountRect counterRect;

	for(Figure* f : fig)
		f->accept(counterRect);
	cout << "Liczba kwadratow = " << counterRect.get() << endl;

	VisitorArea counterArea;

	for(Figure * f : fig)
		f->accept(counterArea);
	cout << "pole pow. = " << counterArea.getArea() << endl;

	VisitMaxSquare maxSquare;

	for(Figure* f : fig)
		f->accept(maxSquare);
	cout << "najwiekszy bok kwadratu = " << maxSquare.getMaxSide() << endl;

	for(Figure * f : fig) delete f;
	return 0;
}
